------------------------------------------------------------------------
--    KaTZ-Pit FC3 functions repo 									  --
------------------------------------------------------------------------

KTZ_MI8_Func =
{

MI8_Export_Data_Slow = function(self)
	
	
	-- Attention !!!!!!!! pour boucle lente, le nom est diffrent que boucle rapide : Device(0) >> MainPanel
		local MainPanel = GetDevice(0)
		-- Test de la prcence de Device 0 , comme table  valide
		if type(MainPanel) ~= "table" then
			return ""
		end
		MainPanel:update_arguments()
		
		-- ============== Valeur Test ============================================================		
		--envoyerInfo(22,MainPanel:get_argument_value(277)*1000)		-- K : Fuel Qty Switch		
	
		-- ============== Horloge de Mission ============================================================		
		envoyerInfo(42,LoGetModelTime())-- Heure de la mission
		
		
		-- ============== Parametres de Vol (lents) ====================================================

		-- ADI
		local ADI_FF = math.floor(MainPanel:get_argument_value(14))		-- ADI Failure Flag
		local ADI_IDX = MainPanel:get_argument_value(820)*1000	-- ADI Index
		local ADI_FI = 50005000 + 10000 * ADI_FF + ADI_IDX
		envoyerInfo(146,ADI_FI)	
		
		-- ALTIRAD : Low Index Setting sur Canal "Altirad_DX"
		envoyerInfo(124,50005000 + MainPanel:get_argument_value(31) * 1000) 
		
		-- Alarme Low et High , Flag on/off
		local Altirad_HF = 0 -- Alti Rad high alti Alarme (pas utilis sur Mi-8)
		local Altirad_LF = math.floor(MainPanel:get_argument_value(30)+0.2) -- Alti Rad low alti Alarme
		local Altirad_O = MainPanel:get_argument_value(35) -- Alti Rad On Button
		envoyerInfo(126,555 + Altirad_HF * 100 + Altirad_LF * 10 + Altirad_O)
		
				
		
		-- ============== Parametres Moteur (lents) ====================================================
		
		local Oil_P_1 = math.floor(MainPanel:get_argument_value(115)*80)	-- Oil Pressure left gradu 0-8 kg/cm
		local Oil_P_2 = math.floor(MainPanel:get_argument_value(117)*80)	-- Oil Pressure right
		local Oil_P_Eng = 50005000 + 10000 * Oil_P_1 + Oil_P_2

		local Oil_PGB_1 = math.floor(MainPanel:get_argument_value(111)*80)	-- Oil Pressure Gear Box
		local Oil_P_GB = 50005000 + Oil_PGB_1		
		

		local Oil_T_1 = math.floor((MainPanel:get_argument_value(116)+0.25) * 200 -50)	-- Oil Temp left : gradu de -50  150 (sortie -0.25 + .75)	
		local Oil_T_2 = math.floor((MainPanel:get_argument_value(118)+0.25) * 200 -50)	-- Oil Temp left : gradu de -50  150 (sortie -0.25 + .75)	
		local Oil_T_Eng = 50005000 + 10000 * Oil_T_1 + Oil_T_2

		local Oil_TGB_1 = math.floor((MainPanel:get_argument_value(114)+0.25) * 200 -50)	-- Oil Temp Gear Box : gradu de -5  15 ( * 200 - 50)	
		local Oil_T_GB = 50005000 + Oil_TGB_1


		envoyerInfo(260,Oil_P_Eng)		-- Engine Oil Pressure (L,R)
		envoyerInfo(265,Oil_P_GB)		-- GearBox Oil Pressure
		envoyerInfo(250,Oil_T_Eng)		-- Engine Oil Temp (L,R)
		envoyerInfo(255,Oil_T_GB)		-- GearBox Oil Temp 	

    
		
		-- Pilototo -------------------------------------------------------------------------------- WIP : a mettre  jour pour Mi-8
				
		
		-- Moteur APU -----------------------------------------------------------------------------------------------------
		-- NEW --- V006 --- Les donnes bolennes de voyants ou d'interrupteur sont groupes dans un seul export
		-- Export nombre  8 chiffres (type : 87654321), chaque position reprend la valeur d'un lment
		-- (0,1 pour les bolens, ou -1,0,1 pour les switches 3 voies, ou 0,1,2,,,9 pour les rotateurs
		-- on ajoute +5 a chaque veleur pour grer 0 et valeurs ngatives
		-- le nombre est dcod dans javascript pour le KaTZ-Pit ou dans SIOC pour les simpit

		-- ============== Dmarrage APU ==============================================

		local APU_V1 = MainPanel:get_argument_value(414)	-- Voyant APU Ignition
		local APU_V2 = MainPanel:get_argument_value(416)	-- Voyant APU Oil Pressure
		local APU_V3 = MainPanel:get_argument_value(417)	-- Voyant APU RPM OK
		local APU_V4 = MainPanel:get_argument_value(418)	-- APU RPM high
		local APU_V = 5555 + APU_V4 * 1000 + APU_V3 * 100 + APU_V2 * 10 + APU_V1
		envoyerInfo(310,APU_V)								-- Chaine Codage Voyants APU (5+A,5+B,5+C,5+D)

		envoyerInfo(315,MainPanel:get_argument_value(412) * 1000)-- APU Type demarrage  (=Start, 1000=Vent, 2000=Crabo)
		
	
		-- ============== Dmarrage Moteur ==============================================
		local COL = MainPanel:get_argument_value(204)
		local COR = MainPanel:get_argument_value(206)
		local BRot = MainPanel:get_argument_value(208)
		local CO = 555 + BRot * 100 + COL * 10 + COR

		envoyerInfo(220,CO)	-- Rotor Break + Levier CutOff Left Right

		local Eng_Start_V = 55 + MainPanel:get_argument_value(420) * 10 + MainPanel:get_argument_value(424)
		envoyerInfo(352,Eng_Start_V)-- Voyant Ignition et Start Engine
				
		envoyerInfo(356,MainPanel:get_argument_value(422) * 1000)-- Selecteur demarrage moteur (zero=APU, 1000=Left, 2000=Right, 3000=Up maintenance)
		envoyerInfo(358,MainPanel:get_argument_value(423) * 1000)-- Type demarrage  (=Start, 1000=Vent, 2000=Crabo)


		-- ============== Parametres Fuel (lents)  =======================================================
		local Fuel_qty = MainPanel:get_argument_value(62)* 1000  -- valeur non linaire  ajuster	
		local Fuel_sel = math.floor(MainPanel:get_argument_value(61) * 10 + 0.2) -- +0.2 pour arrondi selecteur
		local Fuel_data = 50005000 + Fuel_sel*10000 + Fuel_qty
		envoyerInfo(404,Fuel_data) -- Utilisation du canal Fuel Internal Forward

		local Fuel_V1 = MainPanel:get_argument_value(431)	-- Voyant Cross Feed Vanne
		local Fuel_V2 = MainPanel:get_argument_value(427)	-- Voyant Vanne Gauche
		local Fuel_V3 = MainPanel:get_argument_value(429)	-- Voyant Vanne Droit
		local Fuel_V = 555 + Fuel_V1 * 100 + Fuel_V2 * 10 + Fuel_V3
		envoyerInfo(430,Fuel_V)	

		local Fuel_P1 = MainPanel:get_argument_value(441)	-- Voyant Pump Service
		local Fuel_P2 = MainPanel:get_argument_value(442)	-- Voyant Pump Gauche
		local Fuel_P3 = MainPanel:get_argument_value(443)	-- Voyant Pump Droit
		local Fuel_P = 555 + Fuel_P1 * 100 + Fuel_P2 * 10 + Fuel_P3
		envoyerInfo(435,Fuel_P)			
				
			
		-- ============== Parametres Electrique  ===========================================================
		-- Panel DC --------------------------------------------------------------
		-- Regroupement des Voyants AC et DC dans deux valeurs export  8 chiffres	
		local Elec_V1 = MainPanel:get_argument_value(504)		-- Voyant Rec1
		local Elec_V2 = MainPanel:get_argument_value(505)		-- Voyant Rec2
		local Elec_V3 = MainPanel:get_argument_value(506)		-- Voyant Rec3
		local Elec_V4 = MainPanel:get_argument_value(507)		-- Voyant Ground DC
		local Elec_V5 = MainPanel:get_argument_value(508)		-- Voyant Test APU-Rec
				
		local Elec_VDC = 55555 + Elec_V5 * 10000 + Elec_V4 * 1000 + Elec_V3 * 100 + Elec_V2 * 10 + Elec_V1
				
		
		-- Regroupement des Position Switches AC et DC dans deux valeurs export  8 chiffres
		-- Valeur code sur +5 = zero , pour grer facilemet les valeurs ngatives
		-- et les zero non significatifs (dcallage position)
		
		local Elec_S1 = MainPanel:get_argument_value(495)		-- Position Switch Batterie L
		local Elec_S2 = MainPanel:get_argument_value(496)		-- Position Switch Batterie R
		local Elec_S3 = MainPanel:get_argument_value(497)		-- Stby Gen ex APU	
		local Elec_S4 = MainPanel:get_argument_value(499)		-- Position Switch Rectifier 1
		local Elec_S5 = MainPanel:get_argument_value(500)		-- Position Switch Rectifier 2
		local Elec_S6 = MainPanel:get_argument_value(501)		-- Position Switch Rectifier 3
		local Elec_S7 = MainPanel:get_argument_value(502)		-- Position Switch Ground DC
		local Elec_S8 = MainPanel:get_argument_value(503)		-- Rec ex APU	

		local Elec_SW_DC = 55555555 + Elec_S8 * 10000000 + Elec_S7 * 1000000 + Elec_S6 * 100000 + Elec_S5 * 10000 + Elec_S4 * 1000 + Elec_S3 * 100 + Elec_S2 * 10 + Elec_S1
		
		-- envoyerInfo(502,MainPanel:get_argument_value(494) * 1000)-- Position Selecteur Voltmetre DC
		envoyerInfo(504,Elec_SW_DC)								-- Position Switch DC
		envoyerInfo(506,Elec_VDC)								-- Voyant Electric DC
		
		
		-- Panel AC --------------------------------------------------------------

		local Elec_V6 = MainPanel:get_argument_value(543)		-- Voyant Gen1
		local Elec_V7 = MainPanel:get_argument_value(544)		-- Voyant Gen2
		local Elec_V8 = MainPanel:get_argument_value(545)		-- Voyant Ground AC
		local Elec_V9 = MainPanel:get_argument_value(546)		-- Voyant Hacheur DCAC PO500

		local Elec_VAC = 5555 + Elec_V9 * 1000 + Elec_V8 * 100 + Elec_V7 * 10 + Elec_V6		
		
		local EleAc_S1 = MainPanel:get_argument_value(538)		-- Position Switch Generatrice LH
		local EleAc_S2 = MainPanel:get_argument_value(539)		-- Position Switch Generatrice RH
		local EleAc_S3 = MainPanel:get_argument_value(540)		-- Position Switch Ground AC
		local EleAc_S4 = MainPanel:get_argument_value(541)		-- Position Switch Hacheur DCAC 115V
		local EleAc_S5 = MainPanel:get_argument_value(542)		-- Position Switch Hacheur DCAC 36V
		
		local Elec_SW_AC = 55555 + EleAc_S5 * 10000 + EleAc_S4 * 1000 + EleAc_S3 * 100 + EleAc_S2 * 10 + EleAc_S1
		
				
		-- envoyerInfo(512,MainPanel:get_argument_value(535) * 1000)-- Position Selecteur Voltmetre AC
		envoyerInfo(514,Elec_SW_AC)								-- Position Switch AC
		envoyerInfo(516,Elec_VAC)								-- Voyant Electric AC
		
		--envoyerInfo(530,MainPanel:get_argument_value(539) * 1000)-- Stby Gen Load
		
		-- ============== Status Light et NavLight ========================================================
		local Light_S1 = MainPanel:get_argument_value(333)		-- Position Switch Dome_L
		local Light_S2 = MainPanel:get_argument_value(489)		-- Position Switch Dome_R
		local Light_S3 = MainPanel:get_argument_value(513)		-- Position Switch Nav Light
		local Light_S4 = MainPanel:get_argument_value(514)		-- Position Switch Form Light
		local Light_S5 = MainPanel:get_argument_value(515)		-- Position Switch Blade Tip
		local Light_S6 = MainPanel:get_argument_value(516)		-- Position Switch Strobe
		local Light_S7 = MainPanel:get_argument_value(837)		-- Position Switch Landing Light L
		local Light_S8 = MainPanel:get_argument_value(838)		-- Position Switch Landing Light R
		
		local Light_SW = 55555555 + Light_S7 * 10000000 + Light_S8 * 1000000  + Light_S1 * 100000 + Light_S2 * 10000 + Light_S3 * 1000 + Light_S4 * 100 + Light_S5 * 10 + Light_S6
		envoyerInfo(520,Light_SW)								-- Position Switch Lights
	

		-- ============== Status Elments Mcaniques ======================================================== WIP : a mettre  jour pour Mi-8
		envoyerInfo(602,MainPanel:get_argument_value(215))-- Porte Cockpit , 0 ferme , 100 ouverte	
		envoyerInfo(620,MainPanel:get_argument_value(881)*1000)-- Wheel brake
		--envoyerInfo(208,MainPanel:get_argument_value(473)*1000)-- brake pressure
		

		-- ============== Donnes de Navigation ===============================================================	
		-- Doppler Diss15
		
		local DA_100 = math.floor(MainPanel:get_argument_value(799) * 10) -- Diss15 Drift Angle KM
		local DA_10 = math.floor(MainPanel:get_argument_value(800) * 10)
		local DA_1 = math.floor(MainPanel:get_argument_value(801) * 100)
		local DA_F = MainPanel:get_argument_value(802)
		
		local FP_100 = math.floor(MainPanel:get_argument_value(806) * 10) -- Diss15 Flight Path KM
		local FP_10 = math.floor(MainPanel:get_argument_value(807) * 10) 
		local FP_1 = math.floor(MainPanel:get_argument_value(808) * 100) 
		local FP_F = MainPanel:get_argument_value(805)
		
		local MA_100 = math.floor(MainPanel:get_argument_value(811) * 10) -- Diss15 Map Angle
		local MA_10 = math.floor(MainPanel:get_argument_value(812) * 10) 
		local MA_1 = math.floor(MainPanel:get_argument_value(813) * 10 + 0.5) 
		local MA_01 = math.floor(MainPanel:get_argument_value(814) * 60) -- export en minute d'angle
		
		local Dop_On = MainPanel:get_argument_value(817)
		local Dop_Off = MainPanel:get_argument_value(65)

		local Doppler_data1 = 50005000 + FP_100 * 10000000 + FP_10 * 1000000 + FP_1 * 10000 + DA_100 * 1000 + DA_10 * 100 + DA_1 
		local Doppler_data2 = 50005000 + MA_100 * 10000000 + MA_10 * 1000000 + MA_1 * 100000 + MA_01
		local Doppler_flag = Dop_On + DA_F *10 + FP_F * 100 + Dop_Off * 1000 + 5555
		
		envoyerInfo(672,Doppler_data1)
		envoyerInfo(674,Doppler_data2)
		envoyerInfo(676,Doppler_flag)
				
		-- ============== Parametre Diss15  =======================================================		
		-- Drift and Ground indicator
		local DS_V1 = MainPanel:get_argument_value(796)  	-- Voyant Memory
		local DS_V2 = MainPanel:get_argument_value(795)	-- Shutter de l'indication Distance
		
		local DS_V = 55 + DS_V2 * 10 + DS_V1
		
		envoyerInfo(684,DS_V)	-- Diss15 Memory Voyant + Shutter
		
		-- ============== Parametre Ark 9  =======================================================		
		-- Drift and Ground indicator
		local ARK9_S1 = MainPanel:get_argument_value(469)		-- Selection Main-STBY
		local ARK9_S2 = MainPanel:get_argument_value(444)		-- Selection TLF-TLG
		local ARK9_S3 = math.floor(MainPanel:get_argument_value(446) * 10 + 0.3)	-- Selection OFF COMP ANT LOOP (0  3)
		-- ajout de 0.3 avant math.floor pour rgler problmes frquents d'arrondi de DCS
		local ARK9_S4 = math.floor(MainPanel:get_argument_value(451) * 10 + 0.3)		-- Fine Tune MAIN (-2  4)
		local ARK9_S5 = math.floor(MainPanel:get_argument_value(449) * 10 + 0.3)		-- Fine Tune STBY (-2  4)
		
		local ARK9_S = 55555 + ARK9_S5 * 10000 + ARK9_S4 * 1000 + ARK9_S3 * 100 + ARK9_S2 * 10 + ARK9_S1
		
		envoyerInfo(662,ARK9_S)   -- Variable Switch ARK-9
		
		
		local ARK9_MF1 = math.floor(MainPanel:get_argument_value(678) * 20 + 0.3) + 1		-- Freq mHz Main
		local ARK9_MF2 = math.floor(MainPanel:get_argument_value(452) * 10 + 0.3)			-- Freq kHz Main
		-- ajout de 0.3 avant math.floor pour rgler problmes frquents d'arrondi de DCS
		local ARK9_MF =  ARK9_MF1 * 100 + ARK9_MF2 * 10
				
		local ARK9_RF1 = math.floor(MainPanel:get_argument_value(675) * 20 + 0.3)+1		-- Freq Decimal Reserve
		local ARK9_RF2 = math.floor(MainPanel:get_argument_value(450) * 10 + 0.3)		-- Freq Decimal Reserve
		local ARK9_RF =  ARK9_RF1 * 100 + ARK9_RF2 * 10
		
		local ARK9_F =  50005000 + ARK9_RF * 10000 + ARK9_MF
		envoyerInfo(664,ARK9_F)   -- Frquence ARK-9
		
		
		local ARK9_Signal = math.floor(MainPanel:get_argument_value(681) * 1000)
		local ARK9_Gain = math.floor(MainPanel:get_argument_value(448) * 1000)		
		local ARK9_Data = 50005000 + ARK9_Gain * 10000 + ARK9_Signal
		envoyerInfo(666,ARK9_Data)   -- Signal Reception , Rglage Gain	
		
		
		-- ============== Parametre Ark UD  =======================================================		
		-- Position Switches 
		local ARKUD_S1 = math.floor(MainPanel:get_argument_value(456) *10 + 0.2)		-- Selecteur de Mode
		local ARKUD_S2 = MainPanel:get_argument_value(453)		-- Selection sensitivity
		local ARKUD_S3 = MainPanel:get_argument_value(454)		-- Selection VHF UHF
		local ARKUD_S4 = math.floor(MainPanel:get_argument_value(457) * 10 + 0.2)		-- Selecteur de Channel ajout de 0.2 pour pb arrondi
		local ARKUD_S5 = math.floor(MainPanel:get_argument_value(455) * 9.3)		-- Bouton Volume
		local ARKUD_S6 = MainPanel:get_argument_value(458)		-- Voyant 1
		local ARKUD_S7 = MainPanel:get_argument_value(459)		-- Voyant 2
		local ARKUD_S8 = MainPanel:get_argument_value(460)		-- Voyant 3
		
				
		local ARKUD = 55500555 + ARKUD_S8 * 10000000 + ARKUD_S7 * 10000000 + ARKUD_S6 * 1000000 + ARKUD_S5 * 10000 + ARKUD_S4 * 1000 + ARKUD_S3 * 100 + ARKUD_S2 * 10 + ARKUD_S1
		
		envoyerInfo(660,ARKUD)   -- Variable Switch ARK-UD
		
		-- ============== Parametre Selection Ark9-ArkUD  =======================================================		
		-- Position Switches MW/VHF
		envoyerInfo(668,5 + math.floor(MainPanel:get_argument_value(858)+0.2)) 
		
		
		-- ============== Status Armement ==================================================================

		-- Scan du Canon slectionn -------------------------------------------------------------------
		-- Scan du Panel Armement ----------------------------------------------------------------------	


		-- UV-26 -------------------------------------------------------------------		
		-- Export de l'affichage de l'UV26 ----------------------------------------------------------------------
		local uv26 = get_UV26()
		local luv = string.len (uv26)
						
		if luv == 0 then 
			uv26 = 0
		end
		
		envoyerInfo(1040,5000 + uv26)
			
		
		
			local UV_On = math.floor(MainPanel:get_argument_value(910) + 0.2)  -- 0 ou 1
			local LedLeft = MainPanel:get_argument_value(892)
			local LedRight = MainPanel:get_argument_value(891)
			local Side_SW = math.floor(MainPanel:get_argument_value(859) * 2 + 0.2)  -- 0 ou 0.5 ou 1
			local Num_SW = math.floor(MainPanel:get_argument_value(913) + 0.2 )  -- 0 ou 1
			
			envoyerInfo(1042, 55555 + UV_On * 10000 + LedLeft * 1000 + LedRight * 100 + Num_SW * 10 + Side_SW)
			
				
				
		
		
				
		-- ============== Module Alarme ==================================================================================		
		
		    
		
end	,

MI8_Export_Data_Fast = function(self)

	 -- Rcupration des donnes  lire --------------------
		-- Attention !!!!!!!! pour boucle rapide, le nom est diffrent que boucle lente : Device(0) >> lMainPanel
		local lMainPanel = GetDevice(0)
		
		-- Test de la prcence de Device 0 , comme table  valide
		if type(lMainPanel) ~= "table" then
			return ""
		end
		
		
		lMainPanel:update_arguments()
		
		-- ============== Clock =========================================================================
		-- Inutile, time est rcupr avec LoGetModelTime()
		
		
		-- ============== Debug =========================================================================
		envoyerInfo(20,lMainPanel:get_argument_value(342)*1000) 
		envoyerInfo(21,lMainPanel:get_argument_value(343)*1000) 
		envoyerInfo(22,lMainPanel:get_argument_value(344)*1000) 
		envoyerInfo(23,lMainPanel:get_argument_value(345)*1000) 

		-- ============== Contrle de l'appareil =========================================================================		
		--envoyerInfo(123,MainPanel:get_argument_value(191) * 1000)-- Position Collectif , WIP pour Gilles : a mettre  jour pour Mi-8
		--envoyerInfo(22,lMainPanel:get_argument_value(859)*1000)
		
		
		-- ============== Parametres de Vol ===============================================================
		envoyerInfo(102,lMainPanel:get_argument_value(24)*1000) 	-- IAS max speed 350km/hr ... valeur non linaire  ajuster dans html

		envoyerInfo(112,lMainPanel:get_argument_value(19)*10000) 	-- Alti Baro 0-1000m
		envoyerInfo(120,lMainPanel:get_argument_value(34)*1000) 	-- Alti Radar valeur non linaire
		
		envoyerInfo(130,lMainPanel:get_argument_value(16)*1000) 	-- Vario (-30m/s , +30 m/s) ... valeur non linaire  ajuster dans html
		
		envoyerInfo(140,lMainPanel:get_argument_value(12)* -1000)	-- Pitch (ADI)
		envoyerInfo(142,lMainPanel:get_argument_value(13)*1000)	-- Bank ou Roll (ADI)
		
		
		--envoyerInfo(150,lMainPanel:get_argument_value(11)*1000)	-- Boussole
		
		local EUP_S = math.floor(lMainPanel:get_argument_value(22)*1000)	-- EUP_Speed
		local EUP_SS = math.floor(lMainPanel:get_argument_value(23)*1000)	-- EUP_Sideslip
		local EUP = 50005000 + EUP_S * 10000 + EUP_SS
		envoyerInfo(180,EUP)	-- EUP_Data
		
		-- ============== Parametres  ==============================================================
		

		-- ============== Parametres HSI ==================================================================
		
		
		envoyerInfo(152,lMainPanel:get_argument_value(25)*3600) -- CAP (Export 0.1 degrs)
		envoyerInfo(154,lMainPanel:get_argument_value(27)*3600) -- Course (Ecart par rapport  la couronne des caps)
		envoyerInfo(156,lMainPanel:get_argument_value(28)*3600) -- Waypoint (Ecart par rapport  la couronne des caps)
		
				
		-- ============== Parametres ILS ==================================================================
		
		-- ============== Parametres Rotor =================================================================
		
		envoyerInfo(230,lMainPanel:get_argument_value(42)*1100) -- Rotor rpm : max 110
		envoyerInfo(232,lMainPanel:get_argument_value(36)*1000) -- Rotor pitch : gradu de 1  15 ( * 14 +1) ... valeur non linaire  ajuster dans html	
				
				
		-- ============== Parametres Moteur (Fast) ================================================================
		local RPM_L = math.floor(lMainPanel:get_argument_value(40)*1100)		-- rpm left : max 110
		local RPM_R = math.floor(lMainPanel:get_argument_value(41)*1100)		-- rpm right : max 110
		local RPM_data = 50005000 + RPM_L * 10000 + RPM_R
		envoyerInfo(202,RPM_data)									-- Groupage RPM L et R dans une donne
		
		
		local EngT_L =	math.floor(lMainPanel:get_argument_value(43)*1200)		-- temp left : max 120
		local EngT_R = math.floor(lMainPanel:get_argument_value(45)*1200)		-- temp right : max 120
		local EngT = 50005000 + EngT_L * 10000 + EngT_R
		envoyerInfo(204,EngT)									-- Groupage Temprature L et R dans une donne
		
		
		envoyerInfo(210,lMainPanel:get_argument_value(39)*100)		    -- mode moteur Index : gradu de 1  10	
		envoyerInfo(212,lMainPanel:get_argument_value(37)*50 + 50)		-- mode moteur Gauche : gradu de 5  10 ( * 5 +5)	
		envoyerInfo(213,lMainPanel:get_argument_value(38)*50 + 50)		-- mode moteur Droit : gradu de 5  10 ( * 5 +5) 
		-- Variables non groupes pour les simpit
				
		
		-- ============== Parametres APU ===================================================================
		local APU_T = math.floor(lMainPanel:get_argument_value(402) * 1000 )		-- Temprature APU
		local APU_P = math.floor(lMainPanel:get_argument_value(403)	* 1000 )		-- Pression Air comprim de l'APU 
		local APU_data = 50005000 + APU_P * 10000 + APU_T				-- +50005000 pour grer 0 et valeurs ngatives
		
		envoyerInfo(300,APU_data)	-- Groupage Pression + Temprature dans une donne

		-- ============== Position de l'Avion ===============================================================		
		
		
		-- ============== Donnes de Navigation ===============================================================		
		
		
		-- ============== Parametre Drift Indicator  =======================================================		
		-- Drift and Ground indicator
		
		local D_A = math.floor(lMainPanel:get_argument_value(791) * 1000 )  -- Diss15 Drift Angle
								
		local DS_C = lMainPanel:get_argument_value(792) * 10 -- Diss15 Speed x00
		local DS_D = lMainPanel:get_argument_value(793) * 10 -- Diss15 Speed 0x0
		local DS_U = lMainPanel:get_argument_value(794) * 10 -- Diss15 Speed 00x
		
		local Drift_Data = 50005000 + D_A * 10000 + math.floor(DS_C) * 100 + math.floor(DS_D) * 10 + math.floor(DS_U)
		envoyerInfo(682,Drift_Data) 
		
		
		-- Sling indicator		
		
		local Sling_UD = lMainPanel:get_argument_value(828)*1000	-- Up-Down	
		local Sling_LR = lMainPanel:get_argument_value(829)*1000	-- Left Right	
		local Sling_FB = lMainPanel:get_argument_value(830)*1000	-- Forward Back	
		local Sling_Off = lMainPanel:get_argument_value(831) + 0.3	-- Voyant Off (+0.3 pour arrondi  1)	
		
		local Sling_3D = 50005000 + 10000 * math.floor(Sling_Off) + Sling_UD  	-- groupage vario et on/off
		local Sling_2D = 50005000 + 10000 * math.floor(Sling_FB) + Sling_LR					-- groupage avant/arriere et gauche/droite
		
		envoyerInfo(692,Sling_3D) 
		envoyerInfo(694,Sling_2D) 
		   		
		
	end	
	
}