--[[
**************************************************************************
*     Module d'Export de donnes pour SIOC, et le KaTZ-Pit               *
*     Par KaTZe     -         http://www.3rd-wing.net                    *
*     Version 5010a  du   12/02/2015                                     *
**************************************************************************
--]]

-- siocConfig.lua contient :
-- Script de configuration SIOC
-- Paramtres IP : Host, Port
-- Ainsi que la plage d'Offset utilise pour les valeurs KaTZ-Pit 
-- Si l'on veut dcaler la plage rentrer une valeur (ex: 2000)

dofile ( lfs.writedir().."Scripts\\siocConfig.lua" )
dofile ( lfs.writedir()..'/Scripts/KTZ_Base_Function.lua' )
dofile ( lfs.writedir()..'/Scripts/KTZ_Sioc_Function.lua' )
dofile ( lfs.writedir()..'/Scripts/KTZ_FC3_Function.lua' )
dofile ( lfs.writedir()..'/Scripts/KTZ_FPS_Function.lua')

local c



	
------------------------------------------------------------------------
-- 	MAIN PROGRAMME 											  --
------------------------------------------------------------------------


DEBUG_MODE = true; 	-- fichier ..
Sioc_OK = true
Data_Buffer = {}


logCom("Connection  SIOC, ouverture Socket")
package.path  = package.path..";.\\LuaSocket\\?.lua"
package.cpath = package.cpath..";.\\LuaSocket\\?.dll"
socket = require("socket")
	
	
	-- Gestion des erreurs de connection  SIOC
	if pcall(Sioc_connect) then
		logCom("SIOC Connection OK")
		Sioc_OK = true
	else
		logCom("SIOC Connection problme, pas de SIOC")
		Sioc_OK = false
	end
	
local SamplingPeriod_1 = (siocConfig.timing_fast / 1000) or 0.1
local SamplingPeriod_2 = (siocConfig.timing_slow / 1000) or 0.5
local SamplingPeriod_FPS = 5  -- Interval de mesure des fps (dfaut 5 secondes)	

local StartTime = LoGetMissionStartTime()

local CurrentTime = LoGetModelTime()
	-- Va chercher la config IP dans siocConfig
   	--SamplingPeriod_1 = 0.1 -- Interval de squence rapide en secondes (dfaut 100 millisecondes)
	--SamplingPeriod_2 = 0.5   -- Interval de squence lente en secondes (dfaut 0.5 seconde)


	logCom("  ","\n")
	logCom("--- Initialisation du Squenceur ---" ,"\n")
	logCom(string.format(" Mission Start Time (secondes) = %.0f",StartTime,"\n"))	
	logCom(string.format(" Sampling Period 1 = %.1f secondes",SamplingPeriod_1,"\n"))
	logCom(string.format(" Sampling Period 2 = %.1f secondes",SamplingPeriod_2,"\n"))
	logCom(string.format(" Sampling Period FPS = %.1f secondes",SamplingPeriod_FPS,"\n"))

	-- Initialisation des dclencheurs rapides, lents et FPS
local 	NextSampleTime_1 = CurrentTime + SamplingPeriod_1
local 	NextSampleTime_2 = CurrentTime + SamplingPeriod_2
local	NextSampleTime_FPS = CurrentTime + SamplingPeriod_FPS

	logCom("  ","\n")
	logCom("---KaTZe Log: KTZ-FPS-Check Activated ----")
	fps_counter = 0
	fps_max = 0
	fps_min = 0
	fps_tot = 0
	fps_0_10 = 0
	fps_10_20 = 0
	fps_20_30 = 0
	fps_30_40 = 0
	fps_40_50 = 0
	fps_50 = 0
	



if Sioc_OK then
	
	-- Mise  zero du panel armement dans SIOC
	KTZ_FC3_Func:FC3_WeaponInit()
	
	-- Envoi  SIOC de l'heure de dbut de mission
	envoyerInfo(41,StartTime)
	
	
end	



-- Declencheur de squence (depuis export.lua)
------------------------------------------------------------------------
--    Squence : Dmarrage de mission (ExportStart)    			  --
------------------------------------------------------------------------



do
	local PrevLuaExportStart=LuaExportStart;

	LuaExportStart=function()
	
	---- (Hook) Works once just before mission start.
		KTZ_FPS:K_Start(); -- Initialisation du FPS checker
				
		if PrevLuaExportStart then
			PrevLuaExportStart();
		end
	end
end

------------------------------------------------------------------------
--    Squence : avant chaque image            							  --
------------------------------------------------------------------------
-- Rien par dfaut

do
	local PrevLuaExportBeforeNextFrame=LuaExportBeforeNextFrame;

	LuaExportBeforeNextFrame=function()
		-- (Hook) Works just before every simulation frame.
						
		if PrevLuaExportBeforeNextFrame then
			PrevLuaExportBeforeNextFrame();
		end
	end
end

------------------------------------------------------------------------
--    Squence : aprs chaque image            						  --
------------------------------------------------------------------------
-- On compare le time code avec les compteurs de dclenchement

do
	local PrevLuaExportAfterNextFrame=LuaExportAfterNextFrame;

	LuaExportAfterNextFrame=function()
	-- (Hook) Works just after every simulation frame.
	
		fps_counter = fps_counter + 1
		CurrentTime = LoGetModelTime()
		
		if CurrentTime >= NextSampleTime_1 then --*************************************** Boucle Rapide
		
			if Sioc_OK then
				KTZ_FC3_Process:la_petite_chatte() ;  -- Export squence rapide
				Reception_SIOC_Cmd() ; -- Reception Commande
			end
			
			-- calcul de la date de fin du prochain intervalle de temps
			NextSampleTime_1 = CurrentTime + SamplingPeriod_1
			
			
		end
		if CurrentTime >= NextSampleTime_2 then --*************************************** Boucle Lente
			
			if Sioc_OK then
				KTZ_FC3_Process:le_gros_matou();  -- Export squence lente
			end
			-- calcul de la date de fin du prochain intervalle de temps
			NextSampleTime_2 = CurrentTime + SamplingPeriod_2
			
		end
		
		
		if CurrentTime >= NextSampleTime_FPS then --*************************************** Boucle FPS
			
			KTZ_FPS:K_AtInterval();
				
				-- remise  zero du compteur de frame de l'intervalle de temps
			fps_counter = 0
			-- calcul de la date de fin du prochain intervalle de temps
			NextSampleTime_FPS = CurrentTime + SamplingPeriod_FPS
		
		end
			
		if PrevLuaExportAfterNextFrame then
			PrevLuaExportAfterNextFrame();
		end
	end
end


------------------------------------------------------------------------
--    Squence : Fin de mission (ExportStop)         				  --
------------------------------------------------------------------------

do
	local PrevLuaExportStop=LuaExportStop;

	LuaExportStop=function()
	
		KTZ_FPS:K_Stop(); -- Finalisation du FPS checker

		if PrevLuaExportStop then
			PrevLuaExportStop();
		end
	end
end



