------------------------------------------------------------------------
--    KaTZ-Pit Base functions repo 									  --
------------------------------------------------------------------------



------------------------------------------------------------------------
--    Fonction logCom												  --
------------------------------------------------------------------------
function logCom(message)

	-- Cration du fichier de log des communication serveur, s'il n'existe pas
	-- Format , KTZ-SIOC3000_ComLog-yyyymmdd-hhmm.csv
	--
	if DEBUG_MODE and not fichierComLog then
       	fichierComLog = io.open(lfs.writedir().."Logs\\KatzePit\\KaTZPit_Log-"..os.date("%Y%m%d-%H%M")..".csv", "w");
				
		-- Ecriture de l'entte dans le fichier
		if fichierComLog then
			
			fichierComLog:write("*********************************************;\n");
			fichierComLog:write("*     Fichier Log des Communications SIOC   *;\n");
			fichierComLog:write("*     Par KaTZe  -  http://www.3rd-wing.net *;\n");
			fichierComLog:write("*     Version FC3  du 17/02/2015            *;\n");
			fichierComLog:write("*********************************************;\n\n");
		end
    end
	
	-- Ecriture des donnes dans le fichier existant
	if fichierComLog then
        --fichierComLog:write(string.format(" %s ; %s",os.date("%d/%m/%y %H:%M:%S"),message),"\n");
		fichierComLog:write(string.format(" %s ; %s",os.clock(),message),"\n");
	end
end

function getXYCoords(inLatitudeDegrees, inLongitudeDegrees) 
		-- args: 2 numbers // Return two value in order: X, Y
        local pi = 3.141592

		local zeroX = 5000000
		local zeroZ = 6600000

		local centerX = 11465000 - zeroX --circle center
		local centerZ =  6500000 - zeroZ

		local pnSxW_X = 4468608 - zeroX -- point 40dgN : 24dgE
		local pnSxW_Z = 5730893 - zeroZ

		local pnNxW_X = 5357858 - zeroX -- point 48dgN : 24dgE
		local pnNxW_Z = 5828649 - zeroZ

		local pnSxE_X = 4468608 - zeroX -- point 40dgN : 42dgE
		local pnSxE_Z = 7269106 - zeroZ

		local pnNxE_X = 5357858 - zeroX -- point 48dgN : 42dgE
		local pnNxE_Z = 7171350 - zeroZ

		local lenNorth = math.sqrt((pnNxW_X-centerX)*(pnNxW_X-centerX) + (pnNxW_Z-centerZ)*(pnNxW_Z-centerZ))
		local lenSouth = math.sqrt((pnSxW_X-centerX)*(pnSxW_X-centerX) + (pnSxW_Z-centerZ)*(pnSxW_Z-centerZ))
		local lenN_S = lenSouth - lenNorth

		local RealAngleMaxLongitude = math.atan ((pnSxW_Z - centerZ)/(pnSxW_X - centerX)) * 180/pi
		-- borders
		local EndWest = 24
		local EndEast = 42
		local EndNorth = 48
		local EndSouth = 40
		local MiddleLongitude = (EndWest + EndEast) / 2
		local ToLengthN_S = ((EndNorth - EndSouth) / lenN_S)
		local ToAngleW_E = (MiddleLongitude - EndWest) / RealAngleMaxLongitude

		local ToDegree = 360/(2*pi)
	    -- Lo coordinates system
	    local realAng = (inLongitudeDegrees - MiddleLongitude) / ToAngleW_E / ToDegree;
	    local realLen = lenSouth - (inLatitudeDegrees - EndSouth) / ToLengthN_S;
	    local outX = centerX - realLen * math.cos (realAng);
	    local outZ = centerZ + realLen * math.sin (realAng);
	    return outX, outZ
	end	
	
	-- Fonction d'extraction des informations des zones de texte	
function parse_indication(indicator_id)
	local ret = {}
	local li = list_indication(indicator_id)
	if li == "" then return nil end
	local m = li:gmatch("-----------------------------------------\n([^\n]+)\n([^\n]*)\n")
	while true do
        local name, value = m()
        if not name then break end
		ret[name] = value
	end
	return ret
end