-----------------------------------------------------------------------
-- 	Login to SIOC													  --
------------------------------------------------------------------------
    
function Sioc_connect()
	
	-- Va chercher la config IP dans siocConfig
    host = siocConfig.hostIP or "127.0.0.1"
    port = siocConfig.hostPort or 8092
	
	logCom("fonction Sioc_connect")
    

		c = socket.try(socket.connect(host, port)) -- connect to the listener socket
		c:setoption("tcp-nodelay",true) -- set immediate transmission mode
		c:settimeout(.01) -- set the timeout for reading the socket)

	------------------------------------------------------------------------
	-- 	Offset de SIOC qui seront couts								  --
	-- 	0001 = Commande type FC2, FC3										  --
	-- 	0002 = Commande type DCS										  --
	------------------------------------------------------------------------

	inputsTable = {}
	inputsTable [1]=1
	inputsTable [2]=2
	
	local lSIOC_Var, i
    local lSIOC_SendString = ""
    
    -- Generate the init string to SIOC (to register with SIOC which parameters we are interested in)
    for lSIOC_Var,i in pairs(inputsTable)
    do
        lSIOC_SendString = lSIOC_SendString..lSIOC_Var..":"
    end
	
    -- Send the initstring
    socket.try(c:send("Arn.Inicio:"..lSIOC_SendString.."\n"))
	local messageContact = ("Arn.Inicio:"..lSIOC_SendString.."\n")
	
	messageInit = "INIT-->;" .. messageContact
	
end

------------------------------------------------------------------------
-- 	Send Data to SIOC												  --
------------------------------------------------------------------------
function envoyerInfo(strAttribut,valeur)

		-- Option possible : Dcalage des exports vers une plage SIOC
		-- Indiquer dans siocConfig.lua la plage dsire
		-- newAtt = tonumber(strAttribut) + siocConfig.plageSioc
		
		local strNew = tostring(strAttribut)
		
		local strValeur = string.format("%d",valeur);
		
		if (strValeur ~= Data_Buffer[strNew]) then
			-- On stock la nouvelle valeur dans la table buffer
			Data_Buffer[strNew] = strValeur ;
			-- Envoi de la nouvelle valeur
			socket.try(c:send(string.format("Arn.Resp:%s=%.0f:\n",strNew,strValeur)))
			local messageEnvoye = "OUT--> ;" .. (string.format("Arn.Resp:%s=%.0f:",strNew,strValeur))
			-- Log du message envoy
			--logCom(messageEnvoye)
		end		
end

------------------------------------------------------------------------
-- 	Receive Data from SIOC	and act on commande DCS                   --
------------------------------------------------------------------------

function Reception_SIOC_Cmd()
	
	-- Check for data/string from the SIOC server on the socket
    --logCom("*** Fonction recupInfo activated","\n")
	
	-- socket.try(c:send("Arn.Resp"))
	local messageRecu = c:receive()
    
	if messageRecu then
		
		local messagelog = "IN-->;".. tostring(messageRecu)
		--logCom(messagelog)
		
		local s,l,typeMessage = string.find(messageRecu,"(Arn.%w+)");
		typeMessage = tostring(typeMessage);
        
		------------------------------------------------------------
		-- Les types de message accepts :                        --
		--                                                        --
		-- Arn.Vivo   : Le serveur  reu "Arn.Vivo": du client   -- 
		--              Le serveur rpond "Arn.Vivo"              --
		--														  --
		-- Arn.Resp   : Message pour l'execution des commandes    --
		--              a noter que Arn.Resp:1=0: remets le       --
		--              cache valeur  'nil' aussi aprs chaque   --
		--				commande excut                          --
		------------------------------------------------------------
		if typeMessage == "Arn.Resp" then
						
-----------------------------------------------------------------------------
-- 	Lecture du message												  --*************************************************************
----------------------------------------------------------------------------

			-- (message type par exemple :1=3:0=23:6=3456)
			local debut,fin,message = string.find(messageRecu,"([%d:=-]+)")
			-- logCom(message)
			-- longueur du message
			local longueur
			longueur = fin - debut
			--logCom(longueur)
			-- dcoupe du message en commande et envoi  DCS
						
			local commande,Schan,chan,Svaleur,valeur,i,a,b,c,d,e,f,lim,device,bouton,typbouton,val
			lim = 0

			while lim < longueur do
				a,b,commande = string.find(message,"([%d=-]+)", lim)
				--logCom(commande)
				c,d,Schan = string.find(commande, "([%d-]+)")
				chan = tonumber(Schan)
				--logCom(string.format(" Offset = %.0f",chan,"\n"))
				e,f,Svaleur = string.find(commande, "([%d-]+)",d+1)
								
				valeur = tonumber(Svaleur)
				--logCom(string.format(" Valeur = %.0f",valeur,"\n"))
				
				
-----------------------------------------------------------------------------
-- 	Interpretation des commandes										  --*************************************************************
----------------------------------------------------------------------------
				
				-----------------------------------------------------------------
				-- Canal #1 : Commande type FC2
				-----------------------------------------------------------------
				if chan ==1 and valeur > 0 then
						
					-- Envoi  LockOn, commande type Classique FC3
					LoSetCommand(valeur)
				
				end
				
				-----------------------------------------------------------------
				-- Canal #2 : Commande type DCS
				-----------------------------------------------------------------
				
				-- KaTZe Modif BS2, Commande code sur 8 caracteres , TDDBBBPV
				-- T = Type de bouton
				-- DD = Device
				-- BBB = numero du bouton
				-- P = Pas du rotateur
				-- V = Valeur recu
				
				
				if chan ==2 and valeur > 0 then
					typbouton = tonumber(string.sub(Svaleur,1,1))
					device = tonumber(string.sub(Svaleur,2,3))
					bouton = tonumber(string.sub(Svaleur,4,6))
					pas = tonumber(string.sub(Svaleur,7,7))
					val = tonumber(string.sub(Svaleur,8,8))
				
					--logCom(string.format(" Device = %.0f",device,"\n"))
					--logCom(string.format(" Bouton = %.0f",bouton,"\n"))
					--logCom(string.format(" Type = %.0f",typbouton,"\n"))
					--logCom(string.format(" Valeur = %.0f",val,"\n"))
					
					-----------------------------------------------------------------
					-- Type 1 : Simple On/Off
					if typbouton == 1 then
						-- Type interrupteur deux voies
						-- Envoi  LockOn, commande Device, Bouton + 3000 , Argument
						GetDevice(device):performClickableAction(3000+bouton,val)
						
					end
					
					-----------------------------------------------------------------
					-- Type 2 : Simple On/Off avec Capot sur KA50 ... inutilis sur Mi-8 ou UH-1
					-- La squence capot/bouton/capot est cr en 3 commandes successives par javascript
					if typbouton == 2 then
						-- Type interrupteur deux voies, avec capot , val = val * 1000
						-- On ouvre, bascule, ferme
						GetDevice(device):performClickableAction(3000+bouton+1,val)
						GetDevice(device):performClickableAction(3000+bouton,val)
						GetDevice(device):performClickableAction(3000+bouton+1,val)
						
					end
					
					-----------------------------------------------------------------
					-- Type 3 : 3 positions Bas/Mid/Haut
					if typbouton == 3 then
						-- Type interrupteur 3 positions  -1 , 0 , +1
						-- On dcale de -1 i.e. 0>>-1 , 1>>0 , 2>>1
						GetDevice(device):performClickableAction(3000+bouton,(val-1))
																		
					end
					
					-----------------------------------------------------------------
					-- Type 4 : Rotateur Multiple (Dcimal) ... 
					if typbouton == 4 then
					
						-- Type interrupteur rotary , 0.0 , 0.1 , 0.2 , 0.3 , ...
						-- On envoie des valeur de 0  X
					
						if pas < 2 then  -- Pas  0 ou 1, incrment par 0.1
							GetDevice(device):performClickableAction(3000+bouton,val/10)
						end
						
						if pas == 2 then -- Pas  2 , incrment par 0.05
							GetDevice(device):performClickableAction(3000+bouton,val/20)
						end
						
						
												
					end
					-----------------------------------------------------------------
					-- Type 5 : Press Bouton ... commande suivie de mise  zero
					if typbouton == 5 then
						-- Type interrupteur press bouton
						-- On envoie 1 puis zero
						GetDevice(device):performClickableAction(3000+bouton,val)
						GetDevice(device):performClickableAction(3000+bouton,val*0)
												
					end
					
					
					-----------------------------------------------------------------
					-- Type 6 : Rotateur Multiple (Dcimal , Centr sur zero)
					
					if typbouton == 6 then
						-- Rotateur centr sur 0 , pas de 0.1, dcalage ngatif de "pas"/10
						-- exemple si pas = 5 , alors 0 --> -0.5 , 1 --> -0.4 , ... 5 --> 0 , 9 --> 0.4
						GetDevice(device):performClickableAction(3000+bouton,val/10 - pas/10)
																		
					end
					
					
					-----------------------------------------------------------------
					-- Type 7 : Rotateur Multiple (Centsimal)
					if typbouton == 7 then
						-- Rotateur centesimal , incrment = ( 10 * pas + val )/ 100
						GetDevice(device):performClickableAction(3000+bouton,(pas * 10 + val)/100)
																		
					end
					
					
				
				end
								
				lim = b + 1
			end
			
		else
			--logData("---Log: SIOC Message Incorrect ; non type Arn.Resp ; Message Ignor -----", "\n")
		end
    end
end
