------------------------------------------------------------------------
--    KaTZ-Pit FPS functions repo 									  --
------------------------------------------------------------------------


KTZ_FPS =
{

-- Fonction au dmarrage mission
	K_Start=function(self)
		--logCom("  ","\n")
		logCom("*** Fonction K_Start ***","\n")
		--logCom(string.format(" Mission Start Time = %.0f",StartTime,"\n"))	
		--logCom(string.format(" Sampling Period = %.0f secondes",NextSampleTime,"\n"))
		logCom("  ","\n")
	end,


-- Fonction  chaque image
	K_AfterNextFrame=function(self)
		fps_counter = fps_counter + 1
		CurrentTime = LoGetModelTime()
	end,

	
-- Fonction  chaque intervalle de temps
	K_AtInterval=function(self)
		fps_tot = fps_tot + fps_counter -- Compteur du total de frames
		
		-- log(string.format("*** Fonction K_AtInterval @= %.2f",CurrentTime,"\n"))
		-- Classement du nombre de frames de l'intervalle de temps dans l'histogramme
		if fps_counter < 10 * SamplingPeriod then
			fps_0_10 = fps_0_10 + fps_counter
		else
			if fps_counter < 20 * SamplingPeriod then
				fps_10_20 = fps_10_20 + fps_counter
			else
				if fps_counter < 30 * SamplingPeriod then
					fps_20_30 = fps_20_30 + fps_counter
				else
					if fps_counter < 40 * SamplingPeriod then
						fps_30_40 = fps_30_40 + fps_counter
					else
						if fps_counter < 50 * SamplingPeriod then
							fps_40_50 = fps_40_50 + fps_counter
						else
							fps_50 = fps_50 + fps_counter
						end
					end
				end	
			end
		end

	end,

	
	
-- Fonction fin de mission
	K_Stop=function(self)
	
	-- log("*** Fonction K_Stop ***")
	logCom("  ","\n")
		

	-- Calcul des pourcentages de chaque tranche de l'histogramme
	local histo_0_10 = fps_0_10 / fps_tot * 100
	local histo_10_20 = fps_10_20 / fps_tot * 100
	local histo_20_30 = fps_20_30 / fps_tot * 100
	local histo_30_40 = fps_30_40 / fps_tot * 100
	local histo_40_50 = fps_40_50 / fps_tot * 100
	local histo_50 = fps_50 / fps_tot * 100
	

	-- log des rsultats
	logCom(string.format(" Total Number of Frames = %.0f",fps_tot,"\n"))
	logCom(string.format(" Flight Duration = %.0f secondes",CurrentTime,"\n"))
	logCom("  ","\n")
	logCom(string.format("*** Average FPS =  %.1f ",fps_tot/CurrentTime,"\n"))
	logCom("  ","\n")
	logCom(string.format("*** FPS < 10      = %.1f percent",histo_0_10,"\n"))
	logCom(string.format("*** 10 < FPS < 20 = %.1f percent",histo_10_20,"\n"))
	logCom(string.format("*** 20 < FPS < 30 = %.1f percent",histo_20_30,"\n"))
	logCom(string.format("*** 30 < FPS < 40 = %.1f percent",histo_30_40,"\n"))
	logCom(string.format("*** 40 < FPS < 50 = %.1f percent",histo_40_50,"\n"))
	logCom(string.format("*** 50 < FPS      = %.1f percent",histo_50,"\n"))
	logCom("  ","\n")
	logCom("Miaou  tous !!!")
		
	end,

}